//----------------------------------------------------------------------------------
//
// CRVAL : Alterable values et strings
//
//----------------------------------------------------------------------------------
#import "CRVal.h"
#import "CValue.h"
#import "CObjectCommon.h"
#import "CCreateObjectInfo.h"
#import "CDefValues.h"
#import "CDefStrings.h"

@implementation CRVal

-(void)dealloc
{
	int n;
	for (n=0; n<VALUES_NUMBEROF_ALTERABLE; n++)
	{
		if (rvValues[n]!=nil)
		{
			[rvValues[n] release];
		}
	}
	free(rvValues);
	for (n=0; n<STRINGS_NUMBEROF_ALTERABLE; n++)
	{
		if (rvStrings[n]!=nil)
		{
			[rvStrings[n] release];
		}
	}
	free(rvStrings);
	[super dealloc];
}
-(id)initWithHO:(CObject*)ho andOC:(CObjectCommon*)ocPtr andCOB:(CCreateObjectInfo*)cob
{
	self=[super init];
	
	// Creation des tableaux
	rvValueFlags=0;
	rvValues=(CValue**)calloc(VALUES_NUMBEROF_ALTERABLE, sizeof(CValue*));
	rvStrings=(NSString**)calloc(STRINGS_NUMBEROF_ALTERABLE, sizeof(NSString*));

	for (int n=0; n<VALUES_NUMBEROF_ALTERABLE; n++)
		rvValues[n] = [[CValue alloc] initWithInt:0];

	for (int n=0; n<STRINGS_NUMBEROF_ALTERABLE; n++)
		rvStrings[n] = @"";

	// Initialisation des valeurs
	if (ocPtr->ocValues!=nil)
	{
	    for (int n=0; n<ocPtr->ocValues->nValues; n++)
			[rvValues[n] forceInt:ocPtr->ocValues->values[n]];
	}
	if (ocPtr->ocStrings!=nil)
	{
	    for (int n=0; n<ocPtr->ocStrings->nStrings; n++)
			rvStrings[n]=[[NSString alloc] initWithString:ocPtr->ocStrings->strings[n]];

	}
	
	return self;
}
			
-(void)kill:(BOOL)bFast
{
}

-(CValue*)getValue:(int)n
{
	return rvValues[n];
}

-(NSString*)getString:(int)n
{
	return rvStrings[n];
}
-(void)setString:(int)n withString:(NSString*)s
{
	[rvStrings[n] release];
	rvStrings[n]=[[NSString alloc] initWithString:s];
}

@end
