#import <Foundation/Foundation.h>

#define _PI 3.1415926535897932

extern float degreesToRadians(float degrees);
extern float radiansToDegrees(float radians);
extern float Q_rsqrt(float number);

struct Vec2f {
	float x, y;
	Vec2f();
	Vec2f(float x, float y);
	static float distanceBetweenPositions(const Vec2f &a, const Vec2f &b);
	static Vec2f interpolate(const Vec2f &a, const Vec2f &b, double step);
	float distanceToPosition(const Vec2f &point) const;
	void normalize();
	Vec2f normalized();
	void normaliseFast();
	Vec2f normalizedFast();
	Vec2f operator+(const Vec2f &rhs) const;
	Vec2f operator-(const Vec2f &rhs) const;
	Vec2f operator+(const float &rhs) const;
	Vec2f operator-(const float &rhs) const;
	Vec2f operator*(const float rhs) const;
	Vec2f operator/(const float rhs) const;
	Vec2f operator/(const Vec2f &rhs) const;
	bool operator==(const Vec2f &rhs) const;
	bool operator!=(const Vec2f &rhs) const;
};

struct Vec2i {
	int x, y;
	Vec2i();
	Vec2i(int x, int y);
	Vec2i(Vec2f fVec);
	Vec2i operator+(const Vec2i &rhs) const;
	Vec2i operator-(const Vec2i &rhs) const;
	Vec2i operator+(const float &rhs) const;
	Vec2i operator-(const float &rhs) const;
	Vec2i operator*(const float rhs) const;
	Vec2i operator/(const float rhs) const;
	Vec2i operator/(const Vec2i &rhs) const;
	bool operator==(const Vec2i &rhs) const;
	bool operator!=(const Vec2i &rhs) const;
};

const Vec2f Vec2fZero(0,0);
const Vec2f Vec2fOne(1,1);
const Vec2i Vec2iZero(0,0);
const Vec2i Vec2iOne(1,1);

struct Mat3f {
	//float a,b,c,    d,e,f,   g,h,i;
	float a,d,g,    b,e,h,	c,f,i;		//Column major order   (rows are "abc, def, ghi")

	static Mat3f identity();
	static Mat3f zero();
	static Mat3f identityFlippedY();
	static Mat3f translationMatrix(float x, float y);
	static Mat3f translationMatrix(float x, float y, float z);
	static Mat3f scaleMatrix(float x, float y);
	static Mat3f scaleMatrix(float x, float y, float z);
	static Mat3f multiply(Mat3f &a, Mat3f &b);
	static Mat3f multiply(Mat3f &a, Mat3f &b, Mat3f &c, Mat3f &d);
	static Mat3f objectMatrix(const Vec2f &position, const Vec2f &size, const Vec2f &center);
	static Mat3f objectRotationMatrix(const Vec2f &position, const Vec2f &size, const Vec2f &scale, const Vec2f &center, float angle);
	static Mat3f orthogonalProjectionMatrix(int x, int y, int w, int h);

	static Mat3f textureMatrix(float x, float y, float width, float height, float textureWidth, float textureHeight);
	static Mat3f textureMatrixFlipped(float x, float y, float width, float height, float imageHeight, float textureWidth, float textureHeight);
	static Mat3f maskspaceToWorldspace(Vec2f position, Vec2f hotspot, Vec2f scale, float angle);
	static Mat3f worldspaceToMaskspace(Vec2f position, Vec2f hotspot, Vec2f scale, float angle);
	static Mat3f maskspaceToMaskspace(Vec2f positionA, Vec2f hotspotA, Vec2f scaleA, float angleA, Vec2f positionB, Vec2f hotspotB, Vec2f scaleB, float angleB);

	bool operator==(const Mat3f &rhs) const;
	bool operator!=(const Mat3f &rhs) const;

	Mat3f transpose() const;
	float determinant() const;
	Mat3f inverted() const;

	Mat3f flippedTexCoord(bool flipX, bool flipY);

	Vec2f transformPoint(Vec2f point) const;
};


struct ColorRGBA{
	float r, g, b, a;
	ColorRGBA();
	ColorRGBA(int color);
	ColorRGBA(float red, float green, float blue, float alpha);
};

struct GradientColor{
	ColorRGBA a, b, c, d;
	GradientColor();
	GradientColor(int color);
	GradientColor(ColorRGBA color);
	GradientColor(ColorRGBA a, ColorRGBA b, BOOL horizontal);
	GradientColor(ColorRGBA a, ColorRGBA b, ColorRGBA c, ColorRGBA d);
	GradientColor(int a, int b, int c, int d);
	GradientColor(int a, int b, BOOL horizontal);
};
