//
//  CRenderToTexture.h
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 8/10/10.
//  Copyright 2010 Clickteam. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>

#import <OpenGLES/ES2/gl.h>
#import <OpenGLES/ES2/glext.h>
#import "CRect.h"
#import "CTexture.h"

@class CBitmap;
@class CFont;
@class CImage;
class CRenderer;
@class CRunApp;

@interface CRenderToTexture : CTexture
{
@public
	GLuint framebuffer;
	CRunApp* app;
	CRenderer* renderer;
	GLint previousBuffer;
	GLint prevWidth;
	GLint prevHeight;
	BOOL isUploaded;
}
 
- (id)initWithWidth:(int)w andHeight:(int)h andRunApp:(CRunApp*)runApp;
- (void)dealloc;

- (GLuint)newEmptyTextureWithWidth:(int)w andHeight:(int)h;
- (void)bindFrameBuffer;
- (void)unbindFrameBuffer;

- (void)fillWithColor:(int)color;
- (void)fillWithColor:(int)color andAlpha:(unsigned char)alpha;
- (void)clearColorChannelWithColor:(int)color;
- (void)clearWithAlpha:(float)alpha;
- (void)clearWithAlphaDontBind:(float)alpha;
- (void)clearAlphaChannel:(float)alpha;
- (void)copyAlphaFrom:(CRenderToTexture*)rtt;

-(int)uploadTexture;
-(int)deleteTexture;
-(void)cleanMemory;
-(void)setResampling:(BOOL)resample;

@end
