//----------------------------------------------------------------------------------
//
// CRUNMVTPINBALL : movement pinball
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunMvtExtension.h"

#define EFLAG_MOVEATSTART 1
#define MPINFLAG_STOPPED 1

@interface CRunMvtpinball : CRunMvtExtension
{
    int m_dwInitialSpeed;
    int m_dwDeceleration;
    int m_dwGravity;
    int m_dwInitialDir;
    int m_dwFlags;
    double m_gravity;
    double m_xVector;
    double m_yVector;
    double m_angle;
    double m_X;
    double m_Y;
    double m_deceleration;
    int m_flags;	
}
-(int)getGravity;
-(int)getDeceleration;
-(int)getSpeed;
-(double)actionEntry:(int)action;
-(void)setGravity:(int)gravity;
-(void)setDir:(int)dir;
-(void)setSpeed:(int)speed;
-(void)start;
-(void)reverse;
-(void)bounce:(BOOL)bCurrent;
-(void)stop:(BOOL)bCurrent;
-(void)setYPosition:(int)y;
-(void)setXPosition:(int)x;
-(void)setPosition:(int)x withY:(int)y;
-(BOOL)move;
-(double)getVector:(double)vX withVY:(double)vY;
-(double)getAngle:(double)vX withVY:(double)vY;
-(void)initialize:(CFile*)file;

@end
