//----------------------------------------------------------------------------------
//
// CRUNMVTVECTOR
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunMvtExtension.h"

#define MOVEATSTARTVECT 1
#define HANDLE_DIRECTION 2
#define ToDegrees 57.295779513082320876798154814105
#define ToRadians 0.017453292519943295769236907684886

@interface CRunMvtclickteam_vector : CRunMvtExtension
{
    int m_dwFlags;
    int m_dwVel;
    int m_dwVelAngle;
    int m_dwAcc;
    int m_dwAccAngle;
    BOOL r_Stopped;
    BOOL handleDirection;
    double posX;
    double posY;
    double velX;
    double velY;
    double accX;
    double accY;
    double angle;
    double minSpeed;
    double maxSpeed;
	
}
-(void)initialize:(CFile*)file;
-(BOOL)move;
-(void)reset;
-(BOOL)checkSpeed;
-(void)recalculateAngle;
-(void)setPosition:(int)x withY:(int)y;
-(void)setXPosition:(int)x;
-(void)setYPosition:(int)y;
-(void)stop:(BOOL)bCurrent;
-(void)reverse;
-(void)start;
-(void)setSpeed:(int)speed;
-(void)setMaxSpeed:(int)speed;
-(void)setGravity:(int)gravity;
-(double)actionEntry:(int)action;
-(int)getSpeed;
-(int)getGravity;

@end
