//----------------------------------------------------------------------------------
//
// CLAYER : classe layer
//
//----------------------------------------------------------------------------------
#import "CLayer.h"
#import "CFile.h"
#import "CArrayList.h"
#import "CRun.h"
#import "CRunApp.h"

@implementation CLayer

-(id)init
{
	pBkd2=nil;
	pLadders=nil;
	m_loZones = nil;
	scaleX = 1;
	scaleY = 1;
	scale = 1;

	angle = 0;
	xDest = 0;
	yDest = 0;
	xSpot = 0;
	ySpot = 0;

	return self;
}
-(void)dealloc
{
	[pBkd2 clearRelease];
	[pLadders clearRelease];
	[pBkd2 release];
	[pLadders release];
	[pName release];
	
	if(m_loZones != nil)
	{
		[m_loZones clearRelease];
		[m_loZones release];
	}
	[super dealloc];
}
-(void)load:(CFile*)file
{
	dwOptions=[file readAInt];
	xCoef=[file readAFloat];
	yCoef=[file readAFloat];
	nBkdLOs=[file readAInt];
	nFirstLOIndex=[file readAInt];
	pName=[file readAString];
	
	backUp_dwOptions=dwOptions;
	backUp_xCoef=xCoef;
	backUp_yCoef=yCoef;
	backUp_nBkdLOs=nBkdLOs;
	backUp_nFirstLOIndex=nFirstLOIndex;
}
-(Mat3f)getTransformMatrix:(CRun*)run
{
	CRunApp* app		= run->rhApp;
	Vec2f rhHotspot		= Vec2f(app->scXSpot + run->rhWindowX * xCoef, app->scYSpot + run->rhWindowY * yCoef);
	Vec2f destination	= Vec2f(app->scXDest - x * xCoef, app->scYDest - y * yCoef);
	Vec2f lScale		= Vec2f(scaleX * app->scScaleX, scaleY * app->scScaleY);
	Vec2f hotspot		= Vec2f(xSpot, ySpot) + rhHotspot;
	return Mat3f::objectRotationMatrix(destination, Vec2fOne, lScale, hotspot, angle + app->scAngle);
}
-(void)updateVisibleRect:(CRun*)run
{
	visibleRect = CRectCreateAtPosition(run->rhWindowX * xCoef - COLMASK_XMARGIN,
										run->rhWindowY * yCoef - COLMASK_YMARGIN,
										run->rhApp->gaCxWin + COLMASK_XMARGIN,
										run->rhApp->gaCyWin + COLMASK_YMARGIN);
}
@end
