//----------------------------------------------------------------------------------
//
// CRunparser: String Parser object
// fin 14/04/09
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunExtension.h"

@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;
@class CArrayList;

@interface CRunparser : CRunExtension
{
    NSString* source;
    BOOL caseSensitive;
    BOOL wildcards;
    CArrayList* delims; //Strings
    NSString* defaultDelim;
    CArrayList* tokensE; //parserElement	
}
-(int)getSubstringIndex:(NSString*)source withParam1:(NSString*)find andParam2:(int)occurance;
-(void)redoTokens;
-(BOOL)substringMatches:(NSString*)source withParam1:(NSString*)find;

-(void)SP_saveToFile:(NSString*)filename;
-(void)SP_loadFromFile:(NSString*)filename;
-(void)SP_appendToFile:(NSString*)filename;
-(void)SP_appendFromFile:(NSString*)filename;

-(void)SP_saveAsCSV:(NSString*)filename;
-(void)SP_loadFromCSV:(NSString*)filename;
-(void)SP_saveAsMMFArray:(NSString*)filename;
-(void)SP_loadFromMMFArray:(NSString*)filename;
-(void)SP_saveAsDynamicArray:(NSString*)filename;
-(void)SP_loadFromDynamicArray:(NSString*)filename;


@end

@interface StringTokenizer : NSObject
{
	NSArray* array;
	int count;
}	
-(id)initWithParams:(NSString*)s withParam1:(NSString*)d;
-(void)dealloc;
-(int)countTokens;
-(NSString*)nextToken;
@end

@interface parserElement : NSObject
{
@public
	NSString* text;
	int index;
	int endIndex;
}	
-(id)initWithElement:(parserElement*)element;
-(void)setValues:(NSString*)t withParam1:(int)i;
-(void)dealloc;
@end
