//----------------------------------------------------------------------------------
//
// CRunkchisc: Hiscore object
//
//----------------------------------------------------------------------------------



@class CCndExtension;
@class CActExtension;
@class CTextSurface;
@class CIni;
@class ModalInput;
class CRenderer;

#import "CRunExtension.h"
#import "CPoint.h"

@interface CRunkchisc : CRunExtension <UIAlertViewDelegate>
{
	BOOL sVisible;
	short NbScores;
	short NameSize;
	short Flags;
	CFontInfo* Logfont;
	int colorref;
	NSString* Names[20];
	int Scores[20];
	NSString* originalNames[20]; //used for reset action
	int originalScores[20];
	int scrPlayer[4]; //used for high score condition
	NSString* IniName;
	short started;
	CIni* realIni;
	NSNumberFormatter* nformat;
	CTextSurface* textSurface;
	BOOL updated;
	int recordedScore;
	ModalInput* modalInput;
}

-(int)getNumberOfConditions;

-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob  andVersion:(int)version;
-(void)loadRealIniPath:(NSString*)iniName;
-(void)destroyRunObject:(BOOL)bFast;
-(int)handleRunObject;
-(void)displayRunObject:(CRenderer*)renderer;

-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;

-(void)saveHiScores;

//AlertView
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex;

// Conditions
// --------------------------------------------------
-(BOOL)IsPlayerHiScore:(short)player;
-(BOOL)IsVisible;

// Actions
// -------------------------------------------------
-(BOOL)CheckScore:(int)player;
-(void)Hide;
-(void)Show;
-(void)Reset;
-(void)ChangeName:(int)i withName:(NSString*)name;
-(void)ChangeScore:(int)i andScore:(int)score;
-(void)SetPositionX:(int)x andY:(int)y;
-(void)SetXPosition:(int)x;
-(void)SetYPosition:(int)y;
-(void)InsertNewScore:(int)pScore andName:(NSString*)pName;
-(void)SetCurrentFile:(NSString*)fileName;

// Expressions
// --------------------------------------------
-(CValue*)GetValue:(int)i;
-(CValue*)GetName:(int)i;
-(CValue*)GetXPosition;
-(CValue*)GetYPosition;

@end