//----------------------------------------------------------------------------------
//
// CRunkcdirect: Direction Calculator object
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunExtension.h"

@class CObject;
@class CRun;
@class CActExtension;
@class CCndExtension;
@class CBitmap;
@class CCreateObjectInfo;

#define ACT_SET_TURN  0
#define ACT_TURN_DIRECTIONS  1
#define ACT_TURN_POS  2
#define ACT_ADD_DIR  3
#define ACT_DIR_SET  4
#define EXP_XY_TO_DIR  0
#define EXP_XY_TO_SPD  1
#define EXP_DIR_TO_X  2
#define EXP_DIR_TO_Y  3
#define EXP_TURN_TOWARD  4

@interface CRunkcdirect : CRunExtension
{
    int angle_to_turn;
    int speed1;
    int speed2;
    int dir_to_add;
}
-(id)init;
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(void)SetTurn:(int)v;
-(void)TurnToDirection:(int)dir withParam1:(CObject*)object;
-(void)TurnToPosition:(CObject*)object withParam1:(unsigned int)position;
-(void)AddDir_act:(int)speed withParam1:(CObject*)object;
-(void)AngleSet:(int)angle;
-(CValue*)XYtoDir;
-(CValue*)XyToSpeed;
-(CValue*)DirectionToX;
-(CValue*)DirectionToY;
-(CValue*)TurnToward;

@end
