//----------------------------------------------------------------------------------
//
// CRunVideo
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunExtension.h"
#import "MediaPlayer/MediaPlayer.h"

@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;
@class CFontInfo;
@class CBitmap;
@class CImage;



@interface CRuniOSVideo : CRunExtension 
{
    int oldX;
    int oldY;
    int flags;
    short controls;
    short scaling;
    NSString* url;
    int initialPlayback;
    int endPlayback;
    
    MPMoviePlayerController* moviePlayer;
}

-(void)moviePlayBackDidFinish:(NSNotification*)notification;
-(void)resetTouches:(NSNotification*)notification;

-(NSURL*)getURL:(NSString*)file;
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(void)displayRunObject:(CRenderer *)renderer;
-(void)moviePlayBackDidFinish:(NSNotification*)notification;
-(void)startVideo;
-(void)endVideo;
-(BOOL)condition:(int)num withCndExtension:(CCndExtension *)cnd;
-(BOOL)cndAirplayEnabled;
-(BOOL)cndPaused;
-(BOOL)cndStopped;
-(BOOL)cndPlaying;
-(void)action:(int)num withActExtension:(CActExtension *)act;
-(void)actInitialPlayback:(CActExtension*)act;
-(void)actEndPlayback:(CActExtension*)act;
-(void)actRepeat:(CActExtension*)act;
-(CValue*)expression:(int)num;
-(CValue*)expDuration;
-(CValue*)expPlayableDuration;
-(CValue*)expPlaybackTime;
-(CValue*)expState;
-(void)actSetPlaybackTime:(CActExtension*)act;
@end
