//
//  CRuniPhoneStore.m
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 1/25/11.
//  Copyright 2011 Clickteam. All rights reserved.
//

#import "CRuniOSStore.h"

#import "CActExtension.h"
#import "CCndExtension.h"

#import "CExtension.h"
#import "CPoint.h"
#import "CCreateObjectInfo.h"
#import "CFile.h"

#import "CRunApp.h"
#import "CValue.h"
#import "CExtension.h"
#import "CRun.h"
#import "CServices.h"
#import "NSExtensions.h"
#import "Reachability.h"


#define	CND_CANPAYMENTSBEMADE		0
#define CND_ONREQUESTRESPONSE		1
#define CND_ONPAYMENTPURCHASED		2
#define CND_ONPAYMENTFAILED			3
#define CND_ONPAYMENTCANCELED		4
#define CND_ONPAYMENTRESTORED		5

#define CND_ONANYREQUESTRESPONSE	6
#define CND_ONANYPAYMENTPURCHASED	7
#define CND_ONANYPAYMENTFAILED		8
#define CND_ONANYPAYMENTCANCELED	9
#define CND_ONANYPAYMENTRESTORED	10

#define CND_ONINVALIDIDENTIFIER		11
#define CND_ONANYINVALIDIDENTIFIER	12
#define CND_RESTOREPAYMENTSFINISHED	13
#define CND_RESTOREPAYMENTSFAILED	14
#define CND_LAST                    15

#define	ACT_REQUESTPRODUCTSLOT		0
#define ACT_REQUESTPAYMENTSLOT		1
#define ACT_RESTORETRANSACTIONS		2

#define	EXP_PRODUCTNAME				0
#define EXP_PRODUCTDESCRIPTION		1
#define EXP_PRODUCTPRICE			2
#define EXP_PRODUCTPRICELOCALE		3
#define EXP_PRODUCTIDENTIFIER		4
#define EXP_STORERECEIPT			5
#define EXP_PRODUCTQUANTITY			6
#define EXP_ERRORSTRING				7
#define EXP_ERRORNUMBER				8

@implementation CRuniOSStore


-(int)getNumberOfConditions
{
	return CND_LAST;
}

-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{
	productIdentifier = [[NSString alloc] initWithString:@""];
	productName = [[NSString alloc] initWithString:@""];
	productDescription = [[NSString alloc] initWithString:@""];
	localizedPrice = [[NSString alloc] initWithString:@""];
	storeReceipt = [[NSString alloc] initWithString:@""];
	lastErrorString = [[NSString alloc] initWithString:@""];
	lastErrorNumber = -1;
	productPrice = 0;
	validProducts = [[NSMutableDictionary alloc] init];
	currentRequests = [[NSMutableArray alloc] init];
	
	[[SKPaymentQueue defaultQueue] addTransactionObserver:self];
	
	formatter = [[NSNumberFormatter alloc] init];
	[formatter setFormatterBehavior:NSNumberFormatterBehavior10_4];
	[formatter setNumberStyle:NSNumberFormatterCurrencyStyle];
	
	return YES;
}

-(void)destroyRunObject:(BOOL)bFast
{
	//Cancel any ongoing requests
	for(int i=0; i<[currentRequests count]; ++i)
	{
		SKProductsRequest* request = (SKProductsRequest*)[currentRequests objectAtIndex:i];
		[request cancel];
		request.delegate = nil;
	}
	[currentRequests release];
	[[SKPaymentQueue defaultQueue] removeTransactionObserver:self];
	
	if(productIdentifier != nil)
		[productIdentifier release];
	if(productName != nil)
		[productName release];
	if(productDescription != nil)
		[productDescription release];
	if(localizedPrice != nil)
		[localizedPrice release];
	if(storeReceipt != nil)
		[storeReceipt release];
	if(lastErrorString != nil)
		[lastErrorString release];
		
	[formatter release];
	[validProducts release];
}


// Conditions
// --------------------------------------------------
-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd
{
	switch (num)
	{
		case CND_CANPAYMENTSBEMADE:
			return [SKPaymentQueue canMakePayments];
		case CND_ONREQUESTRESPONSE:
		case CND_ONPAYMENTPURCHASED:
		case CND_ONPAYMENTFAILED:
		case CND_ONPAYMENTCANCELED:
		case CND_ONPAYMENTRESTORED:
		case CND_ONINVALIDIDENTIFIER:
			return [productIdentifier isEqualToString:[cnd getParamExpString:rh withNum:0]];
		case CND_ONANYREQUESTRESPONSE:
		case CND_ONANYPAYMENTPURCHASED:
		case CND_ONANYPAYMENTFAILED:
		case CND_ONANYPAYMENTCANCELED:
		case CND_ONANYPAYMENTRESTORED:
		case CND_ONANYINVALIDIDENTIFIER:
        case CND_RESTOREPAYMENTSFINISHED:
        case CND_RESTOREPAYMENTSFAILED:
			return YES;
	}
	return NO;
}

// Actions
// -------------------------------------------------
-(void)action:(int)num withActExtension:(CActExtension*)act
{
	switch (num)
	{
		case ACT_REQUESTPRODUCTSLOT:
			[self act_RequestProductSlot:[act getParamExpString:rh withNum:0]];
			break;
		case ACT_REQUESTPAYMENTSLOT:
		{
			NSString* identifier = [act getParamExpString:rh withNum:0];
			int q = [act getParamExpression:rh withNum:1];
			[self act_RequestPaymentSlot:identifier andQuantity:q];
			break;
		}
        case ACT_RESTORETRANSACTIONS:
            [self act_RestoreTransactions];            
            break;
    }
}

-(void)act_RequestProductSlot:(NSString*)slot
{
	Reachability *networkReachability = [Reachability reachabilityForInternetConnection];
	NetworkStatus networkStatus = [networkReachability currentReachabilityStatus];
	if (networkStatus == NotReachable)
	{
		NSLog(@"Internet connection not available for requesting In-App item information.");
		return;
	}

	//Request product information
	SKProductsRequest* request = [[SKProductsRequest alloc] initWithProductIdentifiers:[NSSet setWithObject:slot]];
	request.delegate = self;
	
	[currentRequests addObject:request];
	[request start];
}

-(void)act_RequestPaymentSlot:(NSString*)slot andQuantity:(int)quantity
{
	Reachability *networkReachability = [Reachability reachabilityForInternetConnection];
	NetworkStatus networkStatus = [networkReachability currentReachabilityStatus];
	if (networkStatus == NotReachable)
	{
		NSLog(@"Internet connection not available for requesting an In-App purchase.");
		return;
	}

	SKProduct* product = [validProducts objectForKey:slot];
	if(product == nil)
	{
		NSLog(@"You need to request product information before requesting a payment!");
		return;
	}
	
	SKMutablePayment* payment = [SKMutablePayment paymentWithProduct:product];
	payment.quantity = quantity;
	[[SKPaymentQueue defaultQueue] addPayment:payment];
}

-(void)act_RestoreTransactions
{
	Reachability *networkReachability = [Reachability reachabilityForInternetConnection];
	NetworkStatus networkStatus = [networkReachability currentReachabilityStatus];
	if (networkStatus == NotReachable)
	{
		NSLog(@"Internet connection not available for restoring In-App purchases.");
		return;
	}
	
    [[SKPaymentQueue defaultQueue] restoreCompletedTransactions];
}
// Expressions
// --------------------------------------------
-(CValue*)expression:(int)num
{
	switch (num)
	{
		case EXP_PRODUCTNAME:
			return [rh getTempString:productName];
		case EXP_PRODUCTDESCRIPTION:
			return [rh getTempString:productDescription];
		case EXP_PRODUCTPRICE:
			return [rh getTempDouble:productPrice];
		case EXP_PRODUCTPRICELOCALE:
			return [rh getTempString:localizedPrice];
		case EXP_PRODUCTIDENTIFIER:
			return [rh getTempString:productIdentifier];
		case EXP_STORERECEIPT:
			return [rh getTempString:storeReceipt];
		case EXP_PRODUCTQUANTITY:
			return [rh getTempValue:productQuantity];
		case EXP_ERRORSTRING:
			return [rh getTempString:lastErrorString];
		case EXP_ERRORNUMBER:
			return [rh getTempValue:lastErrorNumber];
	}
	return [rh getTempValue:0];//won't happen
}

-(void)productsRequest:(SKProductsRequest *)request didReceiveResponse:(SKProductsResponse *)response
{
	for(NSString* invId in response.invalidProductIdentifiers)
	{
		if(invId != nil)
		{
			[productIdentifier release];
			productIdentifier = [[NSString alloc] initWithString:invId];
			[ho generateEvent:CND_ONINVALIDIDENTIFIER withParam:0];
			[ho generateEvent:CND_ONANYINVALIDIDENTIFIER withParam:0];
		}
		else
			NSLog(@"Invalid product itentifier (returned nil) - Unknown error.");
	}

	for(SKProduct* product in response.products)
	{
		[productIdentifier release];
		[productName release];
		[productDescription release];
		[localizedPrice release];
		
		if(product.productIdentifier != nil)
			[validProducts setObject:product forKey:product.productIdentifier];
		else
			NSLog(@"Invalid product identifier returned for valid product! Please check your items in iTunes Connect!");
		
		productName = [[NSString alloc] initWithString:((product.localizedTitle != nil) ? product.localizedTitle : @"")];
		productDescription = [[NSString alloc] initWithString:((product.localizedDescription != nil) ? product.localizedDescription : @"")];
		productPrice = [product.price doubleValue];
        productIdentifier=[[NSString alloc] initWithString:((product.productIdentifier != nil) ? product.productIdentifier : @"")];
		[formatter setLocale:product.priceLocale];
		localizedPrice = [[formatter stringFromNumber:product.price] retain];
		
		[ho generateEvent:CND_ONREQUESTRESPONSE withParam:0];
		[ho generateEvent:CND_ONANYREQUESTRESPONSE withParam:0];
	}
	[currentRequests removeObject:request];
}

-(void)paymentQueue:(SKPaymentQueue *)queue updatedTransactions:(NSArray *)transactions
{
	for(SKPaymentTransaction* transaction in transactions)
	{
		switch (transaction.transactionState)
		{
			case SKPaymentTransactionStatePurchased:
				[productIdentifier release];
				productIdentifier = [[NSString alloc] initWithString:transaction.payment.productIdentifier];
				productQuantity = transaction.payment.quantity;
				[storeReceipt release];
				storeReceipt = [transaction.transactionReceipt base64encode];
				[ho resume];
				[ho generateEvent:CND_ONPAYMENTPURCHASED withParam:0];
				[ho generateEvent:CND_ONANYPAYMENTPURCHASED withParam:0];
				[[SKPaymentQueue defaultQueue] finishTransaction:transaction];
				break;
				
			case SKPaymentTransactionStateFailed:
				[productIdentifier release];
				productIdentifier = [[NSString alloc] initWithString:transaction.payment.productIdentifier];
				productQuantity = transaction.payment.quantity;
				
				[lastErrorString release];
				lastErrorString = [[NSString alloc] initWithString:transaction.error.description];
				lastErrorNumber = transaction.error.code;
				
				[ho resume];
				if(transaction.error.code == SKErrorPaymentCancelled)
				{
					[ho generateEvent:CND_ONPAYMENTCANCELED withParam:0];
					[ho generateEvent:CND_ONANYPAYMENTCANCELED withParam:0];
				}
				else
				{
					[ho generateEvent:CND_ONPAYMENTFAILED withParam:0];
					[ho generateEvent:CND_ONANYPAYMENTFAILED withParam:0];
				}
				
				[[SKPaymentQueue defaultQueue] finishTransaction:transaction];
				break;
				
			case SKPaymentTransactionStateRestored:
				[productIdentifier release];
				productIdentifier = [[NSString alloc] initWithString:transaction.payment.productIdentifier];
				productQuantity = transaction.payment.quantity;
				
				[ho resume];
				[ho generateEvent:CND_ONPAYMENTRESTORED withParam:0];
				[ho generateEvent:CND_ONANYPAYMENTRESTORED withParam:0];
				[[SKPaymentQueue defaultQueue] finishTransaction:transaction];
				break;
				
			default:
				break;
		}
	}
}
- (void)paymentQueueRestoreCompletedTransactionsFinished:(SKPaymentQueue *)queue
{
	[ho resume];
    [ho generateEvent:CND_RESTOREPAYMENTSFINISHED withParam:0]; 
}
- (void)paymentQueue:(SKPaymentQueue *)queue restoreCompletedTransactionsFailedWithError:(NSError *)error
{
	[lastErrorString release];
	lastErrorString = [[NSString alloc] initWithString:error.description];
	lastErrorNumber = error.code;
	
	[ho resume];
    [ho generateEvent:CND_RESTOREPAYMENTSFAILED withParam:0];
}

-(void)paymentQueue:(SKPaymentQueue *)queue removedTransactions:(NSArray *)transactions
{}

-(void)request:(SKRequest *)request didFailWithError:(NSError *)error
{
	[lastErrorString release];
	lastErrorString = [[NSString alloc] initWithString:error.description];
	lastErrorNumber = error.code;
	
	[ho generateEvent:CND_ONANYPAYMENTFAILED withParam:0];
}

@end
