//
//  CRuniPhoneStore.h
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 1/25/11.
//  Copyright 2011 Clickteam. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CRunExtension.h"

#import <StoreKit/StoreKit.h>

@class CCreateObjectInfo;
@class CActExtension;
@class CCndExtension;
@class CFile;
@class CValue;
@class CArrayList;
@class CFontInfo;
@class CListItem;

@interface CRuniOSStore : CRunExtension <SKProductsRequestDelegate, SKRequestDelegate, SKPaymentTransactionObserver>
{
	NSNumberFormatter* formatter;
	
	NSString* productIdentifier;
	NSString* productName;
	NSString* productDescription;
	NSString* localizedPrice;
	NSString* storeReceipt;
	NSString* lastErrorString;
	int		  lastErrorNumber;
	NSMutableDictionary* validProducts;
	double productPrice;
	int productQuantity;
	
	NSMutableArray* currentRequests;
}

-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;

-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;

-(void)act_RequestProductSlot:(NSString*)slot;
-(void)act_RequestPaymentSlot:(NSString*)slot andQuantity:(int)quantity;
-(void)act_RestoreTransactions;

@end
