//
//  CRuniOSBluetooth.m
//  RuntimeIPhone
//
//  Created by Timothy Ellis on 28/04/12.
//  Copyright (c) 2012 Clickteam. All rights reserved.
//

#import "CRuniOSBluetooth.h"

#import "CExtension.h"
#import "CRun.h"
#import "CBitmap.h"
#import "CServices.h"
#import "CCreateObjectInfo.h"
#import "CImage.h"
#import "CActExtension.h"
#import "CCndExtension.h"
#import "CValue.h"

#define MAX_CONDITIONS 5

@implementation CRuniOSBluetooth

@synthesize currentSession;
@synthesize picker;
@synthesize ErrorStr;
@synthesize ErrorCode;

#pragma mark - Bluetooth Specific Code
-(void) sendMsgWithActExt:(CActExtension *)act Reliable:(BOOL)reliable
{
    NSData* data;
    NSString *str = [NSString stringWithString:[act getParamExpString:rh withNum:0]];
    data = [str dataUsingEncoding: NSASCIIStringEncoding];
    [self sendDataToPeers:data Reliable:reliable];
}

- (void)receiveData:(NSData *)data fromPeer:(NSString *)peer inSession:(GKSession *)session context:(void *)context {
    //---convert the NSData to NSString---
//    NSString* str;
//    str = [[NSString alloc] initWithData:data encoding:NSASCIIStringEncoding];
//    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Data received"
//                                                    message:str
//                                                   delegate:self
//                                          cancelButtonTitle:@"OK"
//                                          otherButtonTitles:nil];
//    [alert show];
//    [alert release];
    MsgData = data;
    OnPeerID = peer;
    [ho generateEvent:2 withParam:0];
}

- (void)session:(GKSession *)session peer:(NSString *)peerID didChangeState:(GKPeerConnectionState)state {
    switch (state)
    {
        case GKPeerStateConnected:
            NSLog(@"connected");
            OnPeerID = peerID;
            //On Peer Connected
            [ho generateEvent:0 withParam:0];
            break;
        case GKPeerStateDisconnected:
            NSLog(@"disconnected");
            [self.currentSession release];
            currentSession = nil;
            OnPeerID = peerID;
            //On Disconnect
            [ho generateEvent:1 withParam:0];
            break;
        default:
            break;
    }
}

-(void)peerPickerController:(GKPeerPickerController *)pickerCont didConnectPeer:(NSString *)peerID toSession:(GKSession *)session
{
    self.currentSession = session;
    session.delegate = self;
    [session setDataReceiveHandler:self withContext:nil];
    pickerCont.delegate = nil;
    [pickerCont dismiss];
    [pickerCont autorelease];
    OnPeerID = peerID;
}

- (void)peerPickerControllerDidCancel:(GKPeerPickerController *)pickerCont
{
    pickerCont.delegate = nil;
    [pickerCont autorelease];
    [ho generateEvent:3 withParam:0];
}

- (void) sendDataToPeers:(NSData *) data Reliable:(BOOL)reliable
{
    NSError *err;
    bool sendPktOK = false;
    if (currentSession)
        sendPktOK = [self.currentSession sendDataToAllPeers:data
                                               withDataMode:(reliable ? GKSendDataReliable : GKSendDataUnreliable)
                                                      error:&err];
    if (!sendPktOK)
    {
        if (currentSession)
        {
            //Connected but failed
            ErrorCode = [err code];
            ErrorStr = [err localizedDescription];
        }
        else
        {
            //Not connected generate an error
            ErrorCode = -1;
            ErrorStr = @"Not Connected!";
        }
        
        [ho generateEvent:4 withParam:0];
    }
}

#pragma mark - MMF2 Events and code

//This function should return the number of conditions contained in the object (equivalent to the CND_LAST define in the ext.h file).
-(int)getNumberOfConditions
{
    return MAX_CONDITIONS;
}

/*
 This function is called when the object is created. As iOS object are just created when needed, there is no EDITDATA structure.
 Instead, I send to the function a CFile object, pointing directly to the data of the object (the EDITDATA structure, on disc).
 The CFile object allows you to read the data. It automatically converts PC-like ordering (big or little Indian I cant remember) into iOS ordering.
 It contains functions to read bytes, shorts, int, colors and strings.
 
 So all you have to do, is read the data from the CFile object, and initialise your object accordingly.
 Return YES if your object has been created successfully.
 */
-(BOOL)createRunObject:(CFile *)file withCOB:(CCreateObjectInfo *)cob andVersion: (int)version
{
    OnPeerID = @"";
    MsgData = [[NSData alloc] init];
    ErrorStr = [[NSString alloc] initWithString:@""];
    ErrorCode = 0;
    return YES;
}

/*
 Called when the object is destroyed. This routine should free all the memory allocated during createRunObject.
 bFast is true if the object is destroyed at end of frame. It is false if the object is destroyed in the middle of the application.
 */
-(void)destroyRunObject:(BOOL)bFast
{
    [currentSession release];
    [picker release];
    [ErrorStr release];
}

/*
 Same as the C++ function. Perform all the tasks needed for your object in this function.
 As the C function, this function returns value indicating what to do :
 • REFLAG_ONESHOT : handleRunObject will not be called anymore
 • REFLAG_DISPLAY : displayRunObject is called at next refresh.
 • Return 0 and the handleRunObject method will be called at the next loop.
 */
-(int)handleRunObject
{
    return REFLAG_ONESHOT;
}

//Called when the application goes into pause mode.
-(void)pauseRunObject
{
    
}

//Called when the application restarts.
-(void)continueRunObject
{
    
}

/*
 The main entry for the evaluation of the conditions.
 • num : number of the condition (equivalent to the CND_ definitions in ext.h)
 • cnd : a pointer to a CCndExtension object that contains useful callback functions to get the parameters.
 This function should return YES or NO, depending on the condition.
 */
-(BOOL)condition:(int)num withCndExtension:(CCndExtension *)cnd
{
    switch (num)
    {
        case 0: //On Peer Connected
        case 1: //On Peer Disconnected
        case 2: //On Message Received
        case 3: //On Peer Search Cancelled
        case 4: //On Error
            return YES;
    }
    return NO;
}

/*
 The main entry for the actions.
 • num : number of the action, as defined in ext.h
 • act : pointer to a CActExtension object that contains callback functions to get the parameters.
 */
-(void)action:(int)num withActExtension:(CActExtension *)act
{
    switch (num)
    {
        case 0: //Connect
            picker = [[GKPeerPickerController alloc] init];
            picker.delegate = self;
            picker.connectionTypesMask = GKPeerPickerConnectionTypeNearby;
            [picker show];
            break;
        case 1: //Disconnect
            [self.currentSession disconnectFromAllPeers];
            [self.currentSession release];
            currentSession = nil;
            break;
        case 2: //Send Msg Reliable
            [self sendMsgWithActExt:act Reliable:TRUE];
            break;
        case 3: //Send Msg Unreliable
            [self sendMsgWithActExt:act Reliable:FALSE];
            break;
    }
}

/*
 The main entry for expressions.
 • num : number of the expression
 To get the expression parameters, you have to call the getExpParam method defined in the "ho" variable, for each of the parameters.
 This function returns a CValue* which contains the parameter.
 You then do a getInt(), getDouble() or getString() with the CValue object to grab the actual value.
 This function returns a pointer to a Cvalue object containing the result.
 The content of the CValue can be a integer, a double or a String.
 There is no need to set the HOF_STRING flags if your return a string : the CValue object contains the type of the returned value.
 You should not alloc the CValue yourself, but instead ask for a temporary value from the Crun class :
 [rh getTempValue:default_value] where default_value is an integer.
*/

-(CValue *)expression:(int)num
{
    switch (num)
    {
        case 0: //Peer ID
            return [rh getTempString:OnPeerID];
        case 1: //On Message - Get Msg
            //---convert the NSData to NSString---
            return [rh getTempString:[[NSString alloc] initWithData:MsgData encoding:NSASCIIStringEncoding]];
        case 2:
            return [rh getTempString:ErrorStr];
        case 3:
            return [rh getTempValue:ErrorCode];
    }
    return [rh getTempValue:0];
}

@end
