//
//  CRunWebView.m
//  RuntimeIPhone
//
//  Created by Joshua Lawrence on 8/9/11.
//  Copyright 2011 Clickteam. All rights reserved.
//

#import "CRunWebView.h"
#import "CFile.h"
#import "CRunApp.h"
#import "CBitmap.h"
#import "CCreateObjectInfo.h"
#import "CValue.h"
#import "CExtension.h"
#import "CRun.h"
#import "CCndExtension.h"
#import "CRunView.h"
#import "CServices.h"
#import "CImage.h"
#import "CRect.h"
#import "CRunView.h"
#import "CActExtension.h"

@implementation CRunWebView

-(int)getNumberOfConditions
{
	return 5;
}
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{
	ho->hoImgWidth=[file readAInt];
	ho->hoImgHeight=[file readAInt];
	ret=[file readAShort];
	align=[file readAShort];
	flags=[file readAShort];
	[file skipBytes:40];
	urlAddress=[file readAString];
    
	CGRect frame = CGRectMake(ho->hoX - rh->rhWindowX, ho->hoY - rh->rhWindowY, ho->hoImgWidth, ho->hoImgHeight);
	
	webView = [[UIWebView alloc] initWithFrame:frame];
	webView.backgroundColor = getUIColor(backColor);
    webView.scalesPageToFit=YES;
	
	[rh->rhApp positionUIElement:webView withObject:ho];
    
	if (flags&FLAG_WVVISIBLE)
	{
		webView.hidden=NO;
	}
	else 
	{
		webView.hidden=YES;
	}
	
    
	
	
	
	
	webView.delegate = self;	// let us be the delegate so we know when the keyboard's "Done" button is pressed
	
	[ho->hoAdRunHeader->rhApp->runView addSubview:webView];
	

	
	return YES;
}	


//the next three functions are the self-delegation to set flags for starting,finishing, and failing a load attempt

-(void)webViewDidStartLoad:(UIWebView *)webView 
{
    didStartLoad=YES;
    didFinishLoad=NO;
    didFailLoad=NO;
    [ho pushEvent:CND_WVDIDSTARTLOAD withParam:0];
}


- (void)webViewDidFinishLoad:(UIWebView *)webView
{
    didFinishLoad=YES;
    didFailLoad=NO;
    didStartLoad=NO;
    [ho pushEvent:CND_WVDIDFINISHLOAD withParam:0];
}


-(void)webView:(UIWebView *)webView didFailLoadWithError:(NSError *)loadError
{
    
    didFailLoad=YES;
    didFinishLoad=NO;
    didStartLoad=NO;
    [ho pushEvent:CND_WVDIDFAILLOAD withParam:0];
}


-(void)displayRunObject:(CRenderer*)g2
{
	[rh->rhApp positionUIElement:webView withObject:ho];
}
-(void)destroyRunObject:(BOOL)bFast
{
	[webView removeFromSuperview];
	[webView release];
	[urlAddress release];
}




// Conditions
// --------------------------------------------------
-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd
{
	switch (num)
	{
		case CND_WVISLOADING:
			return [self cndIsLoading];
		case CND_WVISVISIBLE:
			return !webView.hidden;
        case CND_WVDIDSTARTLOAD:
			return didStartLoad;
        case CND_WVDIDFINISHLOAD:
			return didFinishLoad;
        case CND_WVDIDFAILLOAD:
			return didFailLoad;
	}        
	return NO;
}
-(BOOL)cndIsLoading
{
	if( webView.loading )
	{
		return YES;
	}
	return NO;
}







// Actions
// -------------------------------------------------
-(void)action:(int)num withActExtension:(CActExtension*)act
{
	switch (num)
	{        
		case ACT_GOTOURL:
			[self actGotoURL:act]; 
			break;
		case ACT_GOBACK:
            [self actGoBack:act]; 
			break;
		case ACT_GOFORWARD:
            [self actGoForward:act]; 
			break;
        case ACT_WVSHOW:
			webView.hidden=NO;
			break;
		case ACT_WVHIDE:
			webView.hidden=YES;
			break;
	}
}

-(void)actGotoURL:(CActExtension*)act
{
   // [urlAddress release];
    urlAddress=[[NSString alloc] initWithString:[act getParamExpString:rh withNum:0]];
    NSURL *url = [NSURL URLWithString:urlAddress];
    NSURLRequest *requestObj = [NSURLRequest requestWithURL:url];
    [webView loadRequest:requestObj];
}

-(void)actGoForward:(CActExtension*)act
{
    [webView goForward];
}

-(void)actGoBack:(CActExtension*)act
{
    [webView goBack];
}



@end


