//----------------------------------------------------------------------------------
//
// CRunStringTokenizer
//
//----------------------------------------------------------------------------------
#import "CRunStringTokenizer.h"
#import "CActExtension.h"
#import "CCndExtension.h"
#import "CObject.h"
#import "CRun.h"
#import "CArrayList.h"
#import "CCreateObjectInfo.h"
#import "CExtension.h"
#import "CValue.h"

#define ACT0_SPLITSTRING0WITHDELIMITERS11D 0
#define ACT1_SPLITSTRING0WITHDELIMITERS1AND22D 1
#define EXP0_ELEMENTCOUNT 0
#define EXP1_ELEMENT 1
#define EXP2_ELEMENT2D 2
#define EXP3_ELEMENTCOUNTX 3
#define EXP4_ELEMENTCOUNTY 4


@implementation CRunStringTokenizer

-(int) getNumberOfConditions
{
	return 0;
}

-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{
	Tokens=[[CArrayList alloc] init];
	Tokens2D=[[CArrayList alloc] init];
	return YES;
}

-(void)destroyRunObject:(BOOL)bFast
{
	[Tokens clearRelease];
	[Tokens release];
	[self clearTokens2D];
	[Tokens2D release];
}

-(void)clearTokens2D
{
	int i;
	for (i=0; i<[Tokens2D size]; i++)
	{
		CArrayList* array=(CArrayList*)[Tokens2D get:i];
		[array clearRelease];
		[array release];
	}
	[Tokens2D clear];
}

-(void)act0_Splitstring0withdelimiters11D:(CActExtension*)act
{
	NSString* param0 = [act getParamExpString:rh withNum:0];
	NSString* param1 = [act getParamExpString:rh withNum:1];
	[Tokens clearRelease];
	CStringTokeniser* Tokeniser = [[CStringTokeniser alloc] init:param0 withParam:param1];
	int TokenCount = [Tokeniser countTokens];
	int i;
	for(i = 0; i < TokenCount; i++)
	{
		[Tokens add:[[NSString alloc] initWithString:[Tokeniser nextToken]]];
	}
	[Tokeniser release];
}

-(void)act1_Splitstring0withdelimiters1and22D:(CActExtension*)act
{
	NSString* param0 = [act getParamExpString:rh withNum:0];
	NSString* param1 = [act getParamExpString:rh withNum:1];
	NSString* param2 = [act getParamExpString:rh withNum:2];
	[Tokens2D clearRelease];
	
	CStringTokeniser* XTokeniser = [[CStringTokeniser alloc] init:param0 withParam:param1];
	int XTokenCount = [XTokeniser countTokens];
	int x;
	for(x = 0; x < XTokenCount; x++)
	{
		CArrayList* New = [[CArrayList alloc] init];
		CStringTokeniser* YTokeniser=[[CStringTokeniser alloc] init:[XTokeniser nextToken] withParam:param2];
		int YTokenCount = [YTokeniser countTokens];
		int y;
		for(y = 0; y < YTokenCount; y++)
		{
			[New add:[[NSString alloc] initWithString:[YTokeniser nextToken]]];
		}	
		[Tokens2D add:New];
	}	
}

-(void)action:(int)num withActExtension:(CActExtension*)act
{
	switch (num)
	{
		case ACT0_SPLITSTRING0WITHDELIMITERS11D: // '\0'
			[self act0_Splitstring0withdelimiters11D:act];
			break;
			
		case ACT1_SPLITSTRING0WITHDELIMITERS1AND22D: // '\001'
			[self act1_Splitstring0withdelimiters1and22D:act];
			break;
	}
}


-(CValue*)exp0_ElementCount
{
	return [rh getTempValue:[Tokens size]];
}

-(CValue*)exp1_Element
{
	int param0 = [[ho getExpParam] getInt];
	CValue* ret=[rh getTempValue:0];
	NSString* s=(NSString*)[Tokens get:param0];
	if (s==nil)
	{
		s=@"";
	}	        
	[ret forceString:s];
	return ret;
}

-(CValue*)exp2_Element2D
{
	int param0 = [[ho getExpParam] getInt];
	int param1 = [[ho getExpParam] getInt];
	CValue* ret=[rh getTempValue:0];
	NSString* s=(NSString*)[ (CArrayList*)[Tokens2D get:param0] get:param1];
	if (s==nil)
	{
		s=@"";
	}	        
	[ret forceString:s];
	return ret;
}

-(CValue*)exp3_ElementCountX
{
	return [rh getTempValue:[Tokens2D size]];
}

-(CValue*)exp4_ElementCountY
{
	int param0 = [[ho getExpParam] getInt];
	return [rh getTempValue:[ (CArrayList*)[Tokens2D get:param0] size]];
}	    


-(CValue*)expression:(int)num
{
	switch (num)
	{
        case EXP0_ELEMENTCOUNT: // '\0'
            return [self exp0_ElementCount];
				
        case EXP1_ELEMENT: // '\001'
            return [self exp1_Element];
			
        case EXP2_ELEMENT2D: // '\002'
            return [self exp2_Element2D];
				
        case EXP3_ELEMENTCOUNTX: // '\003'
            return [self exp3_ElementCountX];
				
        case EXP4_ELEMENTCOUNTY: // '\004'
            return [self exp4_ElementCountY];
	}
	return nil;
}

@end

@implementation CStringTokeniser


-(id)init:(NSString*)text withParam:(NSString*)delimiter
{
	tokens=[[CArrayList alloc] init];
	
	int oldPos=0;
	NSRange range;
	range=[text rangeOfString:delimiter];
	int pos=range.location;;
	while(pos!=NSNotFound)
	{
		if (pos>oldPos)
		{
			range.location=oldPos;
			range.length=pos-oldPos;
			[tokens add:[[NSString alloc] initWithString:[text substringWithRange:range]]];
		}
		oldPos=pos+[delimiter length];
		if (oldPos>=[text length])
		{
			break;
		}
		range.location=oldPos;
		range.length=[text length]-oldPos;
		range=[text rangeOfString:delimiter options:0 range:range];
		pos=range.location;
	}
	if ([text length]>oldPos)
	{
		range.location=oldPos;
		range.length=[text length]-oldPos;
		[tokens add:[[NSString alloc] initWithString:[text substringWithRange:range]]];
	}
	numToken=0;
	
	return self;
}
-(void)dealloc
{
	[tokens clearRelease];
	[tokens release];
	[super dealloc];
}

-(int)countTokens
{
	return [tokens size];
}
-(NSString*)nextToken
{
	if (numToken<[tokens size])
	{
		NSString* s=(NSString*)[tokens get:numToken++];
		if (s==nil)
		{
			return @"";
		}
		return s;
	}
	return @"";
}

@end
