//
//  CRunRateMe.m
//  RuntimeIPhone
//
//  Created by Timothy Ellis on 20/04/12.
//  Copyright (c) 2012 Clickteam. All rights reserved.
//

#import "CRunRateMe.h"

#import "CExtension.h"
#import "CRun.h"
#import "CBitmap.h"
#import "CServices.h"
#import "CCreateObjectInfo.h"
#import "CImage.h"
#import "CActExtension.h"
#import "CCndExtension.h"
#import "CValue.h"

@implementation CRunRateMe

#pragma mark - UIAlertView Delegate Methods
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (buttonIndex == 0)
    {
        NSString *path = [NSString stringWithFormat:@"https://userpub.itunes.apple.com/WebObjects/MZUserPublishing.woa/wa/addUserReview?id=%d&type=Purple+Software", AppID];
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:path]];
    }
}

-(void) ShowRateMeDialog:(CActExtension *)act{
    
    UIAlertView *Alert;
    Alert = [[UIAlertView alloc] initWithTitle:title
                                       message:msg
                                      delegate:self
                             cancelButtonTitle:bRateText
                             otherButtonTitles: bRateLaterText, bRateNeverText, nil];
    [Alert show];
    [Alert release];
}

#pragma mark - User Funcs
-(void) useDefaults
{
    title          = @"Rate Me";
    msg            = @"Please take a moment and rate us in the App Store";
    bRateText      = @"Rate Now";
    bRateLaterText = @"Remind me later";
    bRateNeverText = @"Don't remind me";
    AppID          = 0;
}

#pragma mark - MMF2 Specifics

//This function should return the number of conditions contained in the object (equivalent to the CND_LAST define in the ext.h file).
-(int)getNumberOfConditions
{
    return 0;
}

/*
 This function is called when the object is created. As iOS object are just created when needed, there is no EDITDATA structure.
 Instead, I send to the function a CFile object, pointing directly to the data of the object (the EDITDATA structure, on disc).
 The CFile object allows you to read the data. It automatically converts PC-like ordering (big or little Indian I cant remember) into iOS ordering.
 It contains functions to read bytes, shorts, int, colors and strings.
 
 So all you have to do, is read the data from the CFile object, and initialise your object accordingly.
 Return YES if your object has been created successfully.
 */
-(BOOL)createRunObject:(CFile *)file withCOB:(CCreateObjectInfo *)cob andVersion: (int)version
{
    [self useDefaults];
    return YES;
}

/*
 Called when the object is destroyed. This routine should free all the memory allocated during createRunObject.
 bFast is true if the object is destroyed at end of frame. It is false if the object is destroyed in the middle of the application.
 */
-(void)destroyRunObject:(BOOL)bFast
{
    
}

/*
 Same as the C++ function. Perform all the tasks needed for your object in this function.
 As the C function, this function returns value indicating what to do :
 • REFLAG_ONESHOT : handleRunObject will not be called anymore
 • REFLAG_DISPLAY : displayRunObject is called at next refresh.
 • Return 0 and the handleRunObject method will be called at the next loop.
 */
-(int)handleRunObject
{
    return REFLAG_ONESHOT;
}

//Called when the application goes into pause mode.
-(void)pauseRunObject
{
    
}

//Called when the application restarts.
-(void)continueRunObject
{
    
}

/*
 The main entry for the evaluation of the conditions.
 • num : number of the condition (equivalent to the CND_ definitions in ext.h)
 • cnd : a pointer to a CCndExtension object that contains useful callback functions to get the parameters.
 This function should return YES or NO, depending on the condition.
 */
#pragma mark - Condition Checking
-(BOOL)condition:(int)num withCndExtension:(CCndExtension *)cnd
{
    return YES;
}

/*
 The main entry for the actions.
 • num : number of the action, as defined in ext.h
 • act : pointer to a CActExtension object that contains callback functions to get the parameters.
 */
#pragma Action Checking
-(void)action:(int)num withActExtension:(CActExtension *)act
{
    switch (num)
    {
        case 0: //Msg Box
            [self ShowRateMeDialog:act];
            break;
        case 1: //Title
            title = [act getParamExpString:rh withNum:0];
            break;
        case 2: //Msg
            msg = [act getParamExpString:rh withNum:0];
            break;
        case 3: //Rate Now Button Txt
            bRateText = [act getParamExpString:rh withNum:0];
            break;
        case 4: //Rate Later Button Txt
            bRateLaterText = [act getParamExpString:rh withNum:0];
            break;
        case 5: //Don't Remind Me Button Text
            bRateNeverText = [act getParamExpString:rh withNum:0];
            break;
        case 6: //Use Defaults
            [self useDefaults];
            break;
        case 7: //App ID
            AppID = [act getParamExpression:rh withNum:0];
            break;
    }
}

/*
 The main entry for expressions.
 • num : number of the expression
 To get the expression parameters, you have to call the getExpParam method defined in the "ho" variable, for each of the parameters.
 This function returns a CValue* which contains the parameter.
 You then do a getInt(), getDouble() or getString() with the CValue object to grab the actual value.
 This function returns a pointer to a Cvalue object containing the result.
 The content of the CValue can be a integer, a double or a String.
 There is no need to set the HOF_STRING flags if your return a string : the CValue object contains the type of the returned value.
 You should not alloc the CValue yourself, but instead ask for a temporary value from the Crun class :
 [rh getTempValue:default_value] where default_value is an integer.
 */
#pragma mark - Expression Checking
-(CValue *)expression:(int)num
{
    return [rh getTempValue:0];
}

/*
 Generate an event with the specific code. The parameter can be recuperated with the [ho getEventParam] method.
 You should prefer the push_event method, specially if your event is generated in another thread than the main thread.
 */
-(void)generateEvent:(int)code withParam:(int)param
{
    
}

/*
 This is the method of choice to generate an event.
 */
-(void)pushEvent:(int)code withParam:(int)param
{
    
}

@end
