//
//  CRunMoveIt.h
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 3/10/11.
//  Copyright 2011 Clickteam. All rights reserved.
//

#import "CRunExtension.h"

@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;
@class CArrayList;
@class CObject;
@class MoveItItem;

@interface CRunMoveIt : CRunExtension
{
	CArrayList* movingObjects;
	CArrayList* queue;
	CObject* triggeredObject;
}
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(int)handleRunObject;
-(void)destroyRunObject:(BOOL)bFast;

-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;

-(MoveItItem*)getItemFromFixed:(int)fixed;
-(MoveItItem*)getItemFromIndex:(int)index;

-(void)moveObject:(CObject*)object andX:(int)x andY:(int)y andCycles:(int)cycles;
-(void)act_moveObjectsWithSpeed:(int)x andY:(int)y andSpeed:(double)speed;
-(void)act_moveObjectsWithTime:(int)x andY:(int)y andTime:(int)time;
-(void)act_stopByFixedValue:(int)fixed;
-(void)act_stopByIndex:(int)index;
-(void)act_stopByObjectSelector:(CObject*)object;
-(void)act_addObjectToQueue:(CObject*)object;
-(void)act_clearQueue;
-(void)act_stopAll;
-(void)act_doMoveStep;

-(CValue*)exp_getNumberOfObjectsMoving;
-(CValue*)exp_fromFixedGetIndex;
-(CValue*)exp_fromFixedGetTotalDistance;
-(CValue*)exp_fromFixedGetRemainingDistance;
-(CValue*)exp_fromFixedGetAngle;
-(CValue*)exp_fromFixedGetDirection;
-(CValue*)exp_fromIndexGetFixed;
-(CValue*)exp_fromIndexGetTotalDistance;
-(CValue*)exp_fromIndexGetRemainingDistance;
-(CValue*)exp_fromIndexGetAngle;
-(CValue*)exp_fromIndexGetDirection;
-(CValue*)exp_onObjectFinnishedGetFixed;

@end



@interface MoveItItem : CRunExtension
{
@public
	CObject* mobject;
	int sourceX;
	int sourceY;
	int destX;
	int destY;
	int cycles;
	int step;
}
-(id)initWithObject:(CObject*)obj andDstX:(int)dstX andDstY:(int)dstY andCycles:(int)numCycles;
-(void)moveToDstX:(int)dstX andDstY:(int)dstY andCycles:(int)numCycles;

@end