//----------------------------------------------------------------------------------
//
// CRUNLOCATION
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "CRunExtension.h"


@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;

#define CND_LOCENABLED 0
#define CND_NEWLOCATION 1
#define ACT_GETLOCATION 0
#define ACT_SETDISTANCEFILTER 1
#define ACT_SETACCURACY 2
#define EXP_LATITUDE 0
#define EXP_LONGITUDE 1
#define EXP_ALTITUDE 2
#define EXP_COURSE 3
#define EXP_SPEED 4
#define EXP_TIMELAST 5
#define EXP_DISTANCEFILTER 6
#define EXP_ACCURACY 7

@interface CRunLocation : CRunExtension <CLLocationManagerDelegate>
{
	int newLocationCount;
	int distance;
	int accuracy;
	BOOL locationUpdated;
	double altitude;
	double latitude;
	double longitude;
	double course;
	double speed;
	BOOL bEnabled;
	int deltaTime;
	CLLocationManager* locationManager;
}

-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(void)locationManager:(CLLocationManager*)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation;
-(CValue*)expression:(int)num;
-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(BOOL)cndNewLocation;
-(BOOL)cndEnabled;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(void)actGetLocation;
-(void)actSetDistance:(int)d;
-(void)actSetAccuracy:(int)acc;
-(CValue*)expLatitude;
-(CValue*)expLongitude;
-(CValue*)expAltitude;
-(CValue*)expCourse;
-(CValue*)expSpeed;

@end
