//----------------------------------------------------------------------------------
//
// CRUNIIF
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import "CRunExtension.h"

@class CCreateObjectInfo;
@class CRun;
@class CBitmap;
@class CFile;

#define EXP_INT_INT 0
#define EXP_INT_STRING 1
#define EXP_INT_FLOAT 2
#define EXP_STRING_INT 3
#define EXP_STRING_STRING 4
#define EXP_STRING_FLOAT 5
#define EXP_FLOAT_INT 6
#define EXP_FLOAT_STRING 7
#define EXP_FLOAT_FLOAT 8
#define EXP_INT_BOOL 9
#define EXP_STRING_BOOL 10
#define EXP_FLOAT_BOOL 11
#define EXP_BOOL_INT 12
#define EXP_BOOL_STRING 13
#define EXP_BOOL_FLOAT 14
#define EXP_LAST_COMP 15

@interface CRunIIF : CRunExtension 
{
	BOOL Last;
}
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(int)handleRunObject;
-(void)displayRunObject:(CRenderer*)renderer;
-(CValue*)expression:(int)num;
-(CValue*)IntInt;
-(CValue*)IntString;
-(CValue*)IntFloat;
-(CValue*)StringInt;
-(CValue*)StringString;
-(CValue*)StringFloat;
-(CValue*)FloatInt;
-(CValue*)FloatString;
-(CValue*)FloatFloat;
-(CValue*)IntBool;
-(CValue*)StringBool;
-(CValue*)FloatBool;
-(CValue*)BoolInt;
-(CValue*)BoolString;
-(CValue*)BoolFloat;
-(CValue*)LastComp;
-(BOOL)CompareInts:(int)p1 withParam1:(NSString*)comp andParam2:(int)p2;
-(BOOL)CompareStrings:(NSString*)p1 withParam1:(NSString*)comp andParam2:(NSString*)p2;
-(BOOL)CompareFloats:(double)p1 withParam1:(NSString*)comp andParam2:(double)p2;

@end
