//----------------------------------------------------------------------------------
//
// CRUNGET: Get object
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>

@class CCreateObjectInfo;
@class CActExtension;
@class CCndExtension;
@class CFile;
@class CValue;

@interface CRunGet : CRunExtension <NSURLConnectionDelegate>
{
	BOOL getPending;
	BOOL usePost;
	NSMutableDictionary* postData;
	NSMutableData* receivedData;
	NSURLConnection* conn;
}
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(int)handleRunObject;
-(void)destroyRunObject:(BOOL)bFast;

//Connection delegates:
-(void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response;
-(void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data;
-(void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error;
-(void)connectionDidFinishLoading:(NSURLConnection *)connection;


-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;


@end
