//
//  CRunForEach.h
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 2/3/12.
//  Copyright (c) 2012 Clickteam. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CRunExtension.h"


@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;
@class CArrayList;
@class CObject;
@class ForEachLoop;
@class ObjectSelection;

@interface CRunForEach : CRunExtension
{
	NSMutableDictionary* forEachLoops;		// Name => ForEachLoop lookup
	NSMutableDictionary* pausedLoops;		// Name => Paused ForEachLoop lookup
	NSMutableDictionary* groups;			// Groupname => CArrayList of objects
	ForEachLoop* currentForEach;
	CObject* currentLooped;
	
	//Variables for the ObjectSelection framework to access
	ForEachLoop* populateLoop;	//To fill with all currently selected objects
	ForEachLoop* partOfLoop;	//To access the loop in question
	CArrayList* partOfGroup;	//To access the group in question
	short oiToCheck;
	NSString* currentGroup;
}
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(BOOL)condition:(int)num withCndExtension:(CCndExtension *)cnd;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;
-(void)executeForEachLoop:(ForEachLoop*)loop;

@end

@interface ForEachLoop : NSObject
{
@public
	NSString* name;
	CArrayList* fvs;
	int loopIndex;
	int loopMax;
	bool paused;
}
-(id)init;
-(void)dealloc;
-(void)addObject:(CObject*)object;
-(void)addFixed:(int)fixed;
@end


BOOL getSelected(CObject* rdPtr, CObject* object);
BOOL getSelectedForGroup(CObject* rdPtr, CObject* object);
BOOL filterPartOfLoop(CObject* rdPtr, CObject* object);
BOOL filterPartOfGroup(CObject* rdPtr, CObject* object);

