//
//  CRunCapture.m
//  RuntimeIPhone
//
//  Created by Kevin Ayre on 18/05/2012.
//  Copyright 2012 Clickteam. All rights reserved.
//


#import "CRunCapture.h"

#import "CFile.h"
#import "CRunApp.h"
#import "CBitmap.h"
#import "CCreateObjectInfo.h"
#import "CValue.h"
#import "CExtension.h"
#import "CRun.h"
#import "CCndExtension.h"
#import "CRMvt.h"
#import "CMove.h"
#import "CRCom.h"


@implementation CRunCapture
@synthesize myFilename;

-(int)getNumberOfConditions
{
	return 0;
}

-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{
//create the Capture object here
//Should read properties from CFile somehow:
    myFilename=@"";
	return YES; //successfully created!
}

-(int)handleRunObject
{
	return 0;
}

-(void)destroyRunObject:(BOOL)bFast
{
     [myFilename release];
}

//Apple suggestion to render UIKit and Camera view (substituting the Camera layer for my openGLES layer)
// Render the UIView into the CGContextRef using the 
// CALayer/-renderInContext: method
- (void)renderView:(UIView*)view inContext:(CGContextRef)context
{
    // -renderInContext: renders in the coordinate space of the layer,
    // so we must first apply the layer's geometry to the graphics context
    CGContextSaveGState(context);
    // Center the context around the window's anchor point
    CGContextTranslateCTM(context, [view center].x, [view center].y);
    // Apply the window's transform about the anchor point
    CGContextConcatCTM(context, [view transform]);
    // Offset by the portion of the bounds left of and above the anchor point
    CGContextTranslateCTM(context,
                          -[view bounds].size.width * [[view layer] anchorPoint].x,
                          -[view bounds].size.height  * [[view layer] anchorPoint].y);
    
    // Render the layer hierarchy to the current context
    [[view layer] renderInContext:context];
    
    // Restore the context
    CGContextRestoreGState(context);
}

//Add UIKit view over an image
-(UIImage*)capture:(UIImage *)image
{ 
    // Create a graphics context with the target size
    CGSize imageSize =CGSizeMake(rh->rhApp->screenRect.size.width, rh->rhApp->screenRect.size.height); //get sceeen size and orientation
    UIGraphicsBeginImageContextWithOptions(imageSize, YES, 0); //YES for Opaque (otherwise get transparent black bars on iPad)    
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    // Draw the given image into the context. 
    // Draw it into the same sized rectangle as the view that is displayed on the screen.
    UIGraphicsPushContext(context);
    [image drawInRect:rh->rhApp->runView.frame]; //-menubarUIOffset)];
    UIGraphicsPopContext();
    
    
    // Render the UIKit  view into the graphic context that we created above.
    [self renderView:rh->rhApp->runView inContext:context];
    //render statusbar somehow?
     // Retrieve the screenshot image containing both the OpenGLES content and the UIKit view
    UIImage *screenshot = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    return screenshot;
    
}


//Apple suggests this,for rendering OpenGLES view
//amended by me (AyreGuitar) as needed
- (UIImage*)snapshot:(CGSize)sizeRect
{
    GLint backingWidth, backingHeight;
    
    // Bind the color renderbuffer used to render the OpenGL ES view
    // If your application only creates a single color renderbuffer which is already bound at this point, 
    // this call is redundant, but it is needed if you're dealing with multiple renderbuffers.
    // Note, replace "_colorRenderbuffer" with the actual name of the renderbuffer object defined in your class.
    //glBindRenderbufferOES(GL_RENDERBUFFER_OES, _colorRenderbuffer);
    
    // Get the size of the backing CAEAGLLayer
    glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_WIDTH_OES, &backingWidth);
    glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_HEIGHT_OES, &backingHeight);
    
    NSInteger x = 0, y = 0, width = backingWidth, height = backingHeight;
    NSInteger dataLength = width * height * 4;
    GLubyte *data = (GLubyte*)malloc(dataLength * sizeof(GLubyte));
    
    // Read pixel data from the framebuffer
    glPixelStorei(GL_PACK_ALIGNMENT, 4);
    glReadPixels(x, y, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);
    
    // Create a CGImage with the pixel data
    // If your OpenGL ES content is opaque, use kCGImageAlphaNoneSkipLast to ignore the alpha channel
    // otherwise, use kCGImageAlphaPremultipliedLast
    CGDataProviderRef ref = CGDataProviderCreateWithData(NULL, data, dataLength, NULL);
    CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
    CGImageRef iref = CGImageCreate(width, height, 8, 32, width * 4, colorspace, 
                                    kCGBitmapByteOrder32Big | kCGImageAlphaNoneSkipLast, //Opaque
                                    ref, NULL, true, kCGRenderingIntentDefault);
    
    // OpenGL ES measures data in PIXELS
    // Create a graphics context with the target size measured in POINTS
    //NSInteger widthInPoints, heightInPoints;
    //widthInPoints = scaleRect.size.width; //rh->rhApp->screenRect.size.width;   //device screen size
    //heightInPoints = scaleRect.size.height; //rh->rhApp->screenRect.size.height; //device screen size
   
    
    //0 does scaling for Retina Screens, but not for iPad vs iPhone
    UIGraphicsBeginImageContextWithOptions(sizeRect, YES, 0); //YES for Opaque
    
    CGContextRef cgcontext = UIGraphicsGetCurrentContext();
    
    // UIKit coordinate system is upside down to GL/Quartz coordinate system
    // Flip the CGImage by rendering it to the flipped bitmap context
    // The size of the destination area is measured in POINTS
    CGContextSetBlendMode(cgcontext, kCGBlendModeCopy);
    CGContextDrawImage(cgcontext, CGRectMake(0.0, 0.0, sizeRect.width, sizeRect.height), iref);
    //CGContextDrawImage(cgcontext, CGRectMake(0.0, 0.0, rh->rhApp->runView.frame.size.width, rh->rhApp->runView.frame.size.height), iref);

    // Retrieve the UIImage from the current context
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    
    // Clean up
    free(data);
    CFRelease(ref);
    CFRelease(colorspace);
    CGImageRelease(iref);
    
    return image;
}

// callback for UIImageWriteToSavedPhotosAlbum
- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo {
    [image release];	 // release image
    //NSLog(@"Save Finished");
}

//save as PNG (Must be a better way of converting the data less!?)
-(void)saveCurrentScreenToPhotoAlbum:(UIImage *)imageTemp {
    NSData *pngData = UIImagePNGRepresentation(imageTemp);
    UIImage *image = [[UIImage alloc] initWithData:pngData];
    UIImageWriteToSavedPhotosAlbum(image, self, @selector(image:didFinishSavingWithError:contextInfo:), nil);	// add callback for finish saving
}


// Conditions
// --------------------------------------------------

//None

// Actions
// -------------------------------------------------
-(void)actOutput_SetFilename:(CActExtension*)act
{
    myFilename=[act getParamExpString:rh withNum:0];
}

//Capture
-(void)actCapture_Screen:(CActExtension*)act
{
    //NSLog(@"CaptureScreen");
    //hook screen capture in here!    
    //use frame size for OpenGLES part
    CGSize scaleSize=CGSizeMake(rh->rhApp->runView.frame.size.width, rh->rhApp->runView.frame.size.height);   //resized frame size
    UIImage* imageOpenGL=[self snapshot:scaleSize];
    UIImage* image=[self capture: imageOpenGL];
    [self saveCurrentScreenToPhotoAlbum:image];
    //NSLog(@"Capture Finished");
}

-(void)action:(int)num withActExtension:(CActExtension*)act
{

	switch (num)
	{
		case 0:
			[self actOutput_SetFilename:act];
			break;
//Only does Capture Screen (for now)
		case 3:
			[self actCapture_Screen:act];
			break;
	}
}


// Expressions
// --------------------------------------------

-(CValue*)exp_getFilename
{
	return [rh getTempString:myFilename];
    
}

-(CValue*)expression:(int)num
{
	switch (num)
	{
		case 0:
			return [self exp_getFilename];
	}
	return nil;
}

@end
