//
//  CRunBox2DJoint.h
//  RuntimeIPhone
//
//  Created by Francois Lionet on 26/11/13.
//  Copyright (c) 2013 Clickteam. All rights reserved.
//

#import "CRunExtension.h"
#import "CRunBox2DBase.h"

typedef struct tagRDATA
{
	LPRDATABASE		base;
	DWORD			flags;
	int				number;
	int             angle1;
	int             angle2;
	int				speed;
	int				torque;
	DWORD			identifier;
	b2Body*			bodyStatic;
	CCArrayList*		joints;
    CRun* rh;
    CExtension* ho;
} RUNDATA;
typedef	RUNDATA*	LPRDATA;

class CJointO
{
public:
	long m_fv1;
	long m_fv2;
	b2RevoluteJoint* m_joint;
	CJointO(CRunMBase* pBase1, CRunMBase* pBase2, b2RevoluteJoint* joint);
};

///////////////////////////////////////////////////////////////////////////////////////////

@interface CRunBox2DJoint : CRunBox2DParent
{
}
-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(int)handleRunObject;
-(void)action:(int)num withActExtension:(CActExtension*)act;
-(CValue*)expression:(int)num;

@end
