//
//  CRunBox2DGround.m
//  RuntimeIPhone
//
//  Created by Francois Lionet on 13/11/13.
//  Copyright (c) 2013 Clickteam. All rights reserved.
//
#import "CRunBox2DGround.h"
#import "CExtension.h"

short gCreateRunObject(LPRDATAGROUND rdPtr, CFile* file);
int gHandleRunObject(LPRDATAGROUND rdPtr);

short gCreateRunObject(LPRDATAGROUND rdPtr, CFile* file)
{
    rdPtr->obstacle = [file readAShort];
    rdPtr->direction = [file readAShort];
    rdPtr->friction = (float)((float)[file readAInt] / 100.0f);
    rdPtr->restitution = (float)((float)[file readAInt] / 100.0f);
    rdPtr->identifier = [file readAInt];
	return NO;
}

int gHandleRunObject(LPRDATAGROUND rdPtr)
{
	return REFLAG_ONESHOT;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation CRunBox2DGround

-(int)getNumberOfConditions
{
	return 0;
}

-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{
    m_object = malloc(sizeof(RUNDATAGROUND));
    
    LPRDATAGROUND rdPtr = (LPRDATAGROUND)m_object;
    rdPtr->rh = ho->hoAdRunHeader;
    rdPtr->ho = ho;
    gCreateRunObject(rdPtr, file);
    
	return NO;
}

-(int)handleRunObject
{
	return REFLAG_ONESHOT;
}


@end