//----------------------------------------------------------------------------------
//
// Angle Extension
//
//----------------------------------------------------------------------------------
#import "CRunAngle.h"
#import "CFile.h"
#import "CRunApp.h"
#import "CBitmap.h"
#import "CCreateObjectInfo.h"
#import "CValue.h"
#import "CExtension.h"
#import "CRun.h"
#import "CCndExtension.h"

#define CND_LAST 1;

@implementation CRunAngle

-(int)getNumberOfConditions
{
	return CND_LAST;
}

// Startup
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version
{    
    // Set
    currentAngle = 0;
    
    // Start
    [[UIAccelerometer sharedAccelerometer] setUpdateInterval:1.0/15];
    [[UIAccelerometer sharedAccelerometer] setDelegate:self];
    
	// Return
	return YES;
}

// Clean up
-(void)destroyRunObject:(BOOL)bFast
{
}

// Delegates
// -----------------------------------------------

- (void) accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration {
    
    // Get the current device angle
    float xx = -[acceleration x];
    float yy = [acceleration y];
    float angle = atan2(yy, xx);
    
    // Multiply by 60 to give it a real value
    angle *= 60;
    
    // Add 90 to account for where the phone angle accounts for vertical
    angle += 90;
    
    // Still negative?  Add 360
    if ( angle < 0 )
    {
        // Set
        currentAngle = (int)angle + 360;
    } else {
        // Set
        currentAngle = (int)angle;
    }
    
    // Adjust for inversion of values
    currentAngle = 360 - currentAngle;
    
    // Make sure it's 0-359
    if ( currentAngle > 359 )
        currentAngle = 0;
    
    // Return
    return;
}

// Expressions
// -----------------------------------------------
-(CValue*)expression:(int)num
{
    switch (num) {
        case EXP_CURRENT_ANGLE:
            return [self CurrentAngle];
        default:
            return [rh getTempValue:0]; // won't be used
    }
}

-(CValue*)CurrentAngle
{
    return [rh getTempValue:currentAngle];
}

@end
