//----------------------------------------------------------------------------------
//
// CRUNIPHONEACC iPhone accelerometers
//
//----------------------------------------------------------------------------------
#import <Foundation/Foundation.h>
#import <CoreMotion/CoreMotion.h>
#import "CRunExtension.h"

#define EXP_XDIRECT 0
#define EXP_YDIRECT 1
#define EXP_ZDIRECT 2
#define EXP_XGRAVITY 3
#define EXP_YGRAVITY 4
#define EXP_ZGRAVITY 5
#define EXP_XINSTANT 6
#define EXP_YINSTANT 7
#define EXP_ZINSTANT 8
#define EXP_ORIENTATION 9
#define CND_ORIENTATIONCHANGED 0

@class CFile;
@class CCreateObjectInfo;
@class CValue;
@class CCndExtension;

@interface CRunAccelerometer : CRunExtension
{
	int orientationCount;
	int oldOrientation;
	CMMotionManager* motionManager;
	CMAcceleration acceleration;
}

-(int)getNumberOfConditions;
-(BOOL)createRunObject:(CFile*)file withCOB:(CCreateObjectInfo*)cob andVersion:(int)version;
-(void)destroyRunObject:(BOOL)bFast;
-(CValue*)expression:(int)num;
-(BOOL)condition:(int)num withCndExtension:(CCndExtension*)cnd;
-(BOOL)orientationChanged;

@end
