//
//  CTexture.m
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 9/28/13.
//  Copyright (c) 2013 Clickteam. All rights reserved.
//

#import "CTexture.h"

@implementation CTexture


-(int)uploadTexture
{
	return 0;
}

-(int)deleteTexture
{
	return 0;
}

-(void)generateMipMaps
{

}

-(void)cleanMemory
{

}

-(void)expectTilableImage
{

}

-(void)setResampling:(BOOL)_resample
{
	if(resample != _resample)
	{
		resample = _resample;
		[self updateFilter];
	}
}

-(void)updateFilter
{
	glBindTexture(GL_TEXTURE_2D, textureId);
	if(resample)
	{
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, ((hasMipMaps) ? GL_LINEAR_MIPMAP_LINEAR : GL_LINEAR));
	}
	else
	{
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, ((hasMipMaps) ? GL_NEAREST_MIPMAP_NEAREST : GL_NEAREST));
	}
}

-(void)updateTextureMatrix
{
	if(!coordsAreSwapped)
		textureMatrix = Mat3f::textureMatrix(0, 0, width, height, textureWidth, textureHeight);
	else
		textureMatrix = Mat3f::textureMatrixFlipped(0, 0, width, height, height, textureWidth, textureHeight);
}

@end
