//
//  CTexture.h
//  RuntimeIPhone
//
//  Created by Anders Riggelsen on 9/28/13.
//  Copyright (c) 2013 Clickteam. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CoreMath.h"

enum TextureQuality {
	RGBA8888,	//32 bit
	RGBA4444,	//16 bit
	RGBA5551,	//16 bit
	RGB888,		//24 bit
	RGB565		//16 bit
};

@interface CTexture : NSObject
{
@public
	int handle;
	GLuint textureId;
	int width;
	int height;
	int originalWidth;
	int originalHeight;
	int textureWidth;
	int textureHeight;
	int usageCount;
	BOOL resample;		//MUST be set with 'setResampling' so it can update the filters
	BOOL hasMipMaps;

	GLuint wrapS;
	GLuint wrapT;

	Mat3f textureMatrix;
	BOOL coordsAreSwapped;
}

-(int)uploadTexture;
-(int)deleteTexture;
-(void)generateMipMaps;
-(void)cleanMemory;
-(void)expectTilableImage;

-(void)setResampling:(BOOL)resample;
-(void)updateFilter;

-(void)updateTextureMatrix;

@end
