// --------------------------------------------------------------------------
// 
// ACCELERATOR JOYSTICK
// 
// --------------------------------------------------------------------------
#import "CJoystickAcc.h"
#import "CRunApp.h"

@implementation CJoystickAcc

-(id)initWithApp:(CRunApp*)a
{
	if(self = [super init])
	{
		app=a;
		motionManager = [[CMMotionManager alloc] init];
		if(motionManager.accelerometerAvailable)
			[motionManager startAccelerometerUpdates];
	}
	return self;
}
-(void)dealloc
{
	[motionManager stopAccelerometerUpdates];
	[motionManager release];
	[super dealloc];
}

#define MAX_POSITIONX 3
#define MAX_POSITIONY 3
#define CENTER_POSITIONX 2
#define CENTER_POSITIONY 2

-(int)getJoystick
{
	acceleration = motionManager.accelerometerData.acceleration;
	joystick=0;
	if (acceleration.x < -0.1)
		joystick|=0x04;
	if (acceleration.x > 0.1)
		joystick|=0x08;
	if (acceleration.y < -0.1)
		joystick|=0x02;
	if (acceleration.y > 0.1)
		joystick|=0x01;

	return joystick;
}

@end
